function [Spec,Header]=get1_sdss_spec(FileName);
%------------------------------------------------------------------------------------
% get1_sdss_spec function        Given SDSS spectra file name in fits format,
%                              uses ftools to extract the spectrum from the
%                              file along with some header information.
% Input  : - SDSS spectra file name in fits format.
% Output : - Spectrum matrix, with NAXIS1 raws and four colums.
%            The columns are: [Wavelength (Ang),
%                              Flux (erg/cm^2/sec/Ang),
%                              Continuum subtracted flux(erg/cm^2/sec/Ang),
%                              Flux Sigma (erg/cm^2/sec/Ang),
%                              Mask].
%            For more details about mask see sdss_spec_mask_array.m
%          - Header structure:
%              Header.FILENAME   : FITS file name
%              Header.NAXIS1     : number of pixels in spectrum
%              Header.CRVAL1     : CRVAL1 (log. zeropoint)
%              Header.CD1_1      : CD1_1 (log. dispersion)
%              Header.RAOBJ      : Obj. R.A. in deg. [J2000.0]
%              Header.DECOBJ     : Obj. Dec. in deg. [J2000.0]  
%              Header.AZ         : Telescope Az. in deg.
%              Header.ALT        : Telescope Alt. in deg.
%              Header.MJD        : Modified JD
%              Header.TAI        : Number of seconds since Nov 17 1858 (TAI)
%              Header.FIBERID    : Fiber ID
%              Header.PMAG_U     : Photometry u mag.
%              Header.PMAG_G     : Photometry g mag.
%              Header.PMAG_R     : Photometry r mag.
%              Header.PMAG_I     : Photometry i mag.
%              Header.PMAG_Z     : Photometry z mag.
%              Header.SMAG_G     : Synthetic g mag.
%              Header.SMAG_R     : Synthetic r mag.
%              Header.SMAG_I     : Synthetic i mag.
%              Header.Z          : Final redshift
%              Header.Z_ERR      : Redshift error
%              Header.Z_CONF     : Redshift confidence
%              Header.Z_STATUS   : Redshift Status
%              Header.Z_WARNIN   : Redshift Warning Flags
%              Header.OBJID      : Object ID vector [Run, Rerun, CamCol, Field, ID]
% Tested : MATLAB 5.3
%     By : Ohad Shemmer & Eran O. Ofek          December 2001
%    URL : http://wise-obs.tau.ac.il/~eran/matlab.html
%------------------------------------------------------------------------------------

eval(['!cp ',FileName,' tmp.fits']);

% Start FTOOLS
% ft is an alias of the form:
%!alias shea 'source $LHEASOFT/lhea-init.csh'

% Apparently, one should first type 'ft' in the xterm's command line
% BEFORE running matlab!!!

%--- Read the following data:
% NAXIS1 - number of pixels
% CRVAL1 -
% CD1_1  -
% RAOBJ  - RA in deg.
% DECOBJ - Dec. in deg.
% AZ     - Azimuth
% ALT    - Altitude
% MJD    - modified JD
% TAI    - Number of seconds since Nov 17 1858
% FIBERID- fiber ID
% MAG    - photometry mag u,g,r,i,z
% MAG_G  - synthetic photometry in g
% MAG_R  - synthetic photometry in r
% MAG_I  - synthetic photometry in i
% Z      - Final redshift
% Z_ERR  - Redshift error
% Z_CONF - Redshift confidence
% Z_STATUS- Redshift Status
% Z_WARNIN- Redshift Warning Flags
% OBJID  - object id [run,rerun,...]

!source $LHEASOFT/lhea-init.csh ; ffilecat "tmp.fits[0]" tmp_header.fits "NAXIS1 CRVAL1 CD1_1 RAOBJ DECOBJ AZ ALT MJD TAI FIBERID MAG MAG_G MAG_R MAG_I Z Z_ERR Z_CONF Z_STATUS Z_WARNIN" omit=no quiet=yes

!source $LHEASOFT/lhea-init.csh ; fdump "tmp_header.fits[1]" tmp_header.txt columns="NAXIS1 CRVAL1 CD1_1 RAOBJ DECOBJ AZ ALT MJD TAI FIBERID MAG MAG_G MAG_R MAG_I Z Z_ERR Z_CONF Z_STATUS Z_WARNIN" rows=-1 prhead=no prdata=yes showcol=no showunit=no showrow=no showscale=no align=no clobber=yes

FID = fopen('tmp_header.txt','r');
HeaderPars = fscanf(FID,'%f',Inf);
fclose(FID);
Header.FILENAME = FileName;
Header.NAXIS1   = HeaderPars(1);
Header.CRVAL1   = HeaderPars(2);
Header.CD1_1    = HeaderPars(3);
Header.RAOBJ    = HeaderPars(4);
Header.DECOBJ   = HeaderPars(5);
Header.AZ       = HeaderPars(6);
Header.ALT      = HeaderPars(7);
Header.MJD      = HeaderPars(8);
Header.TAI      = HeaderPars(9);
Header.FIBERID  = HeaderPars(10);
Header.PMAG_U   = HeaderPars(11);
Header.PMAG_G   = HeaderPars(12);
Header.PMAG_R   = HeaderPars(13);
Header.PMAG_I   = HeaderPars(14);
Header.PMAG_Z   = HeaderPars(15);
Header.SMAG_G   = HeaderPars(16);
Header.SMAG_R   = HeaderPars(17);
Header.SMAG_I   = HeaderPars(18);
Header.Z        = HeaderPars(19);
%Header.Z_ERR    = HeaderPars(20);
%Header.Z_CONF   = HeaderPars(21);
%Header.Z_STATUS = HeaderPars(22);
%Header.Z_WARNIN = HeaderPars(23);
%Header.OBJID    = HeaderPars(24:28);


% read fits image and write it as a fits table
!source $LHEASOFT/lhea-init.csh ; fim2lst tmp.fits tmp_out.fits x="pixel_num" y="row" value="counts" extnam="spectrum" copyall=yes clobber=yes

% dump the fits table as ascii file
!source $LHEASOFT/lhea-init.csh ; fdump "tmp_out.fits" tmp_out.txt columns="pixel_num counts" rows=- prhead=no prdata=yes showcol=no showunit=no showrow=no showscale=no align=no clobber=yes

Data = load('tmp_out.txt');
% calculate the number of enteries per pixels
[SizeDI, SizeDJ]=size(Data);
if (SizeDJ~=2),
   error('Unknown file format');
end
NCol = SizeDI./Header.NAXIS1;
if (NCol~=floor(NCol)),
   error('File is truncated');
end

%--- Read info assuming there are 4 columns ---
% Column  : Value in units 1e-17 erg/cm^2/sec/A
% Column  : Continuum subtracted value in units 1e-17 erg/cm^2/sec/A
% Column  : S/N
% Column  : bit mask
NormConst = 1e-17;

PixNum = Data([1:NCol:end-(NCol-1)],1);
Flux   = Data([1:NCol:end-(NCol-1)],2).*NormConst;
FluxCS = Data([2:NCol:end-(NCol-2)],2).*NormConst;
SN     = Data([3:NCol:end-(NCol-3)],2).*NormConst;
Mask   = Data([4:NCol:end-(NCol-4)],2);
Q = Header.CD1_1;
A = Header.CRVAL1;
N = Header.NAXIS1;
WaveA  = 10.^(A + [0:1:N-1].' .* Q);

Spec = [WaveA, Flux, FluxCS, SN, Mask];

!'rm' tmp*


