function RES = greene(fits_filename , begin_wave , stop_wave , center ,toll , filters, mask_type)

% This function is build to deal with the Greene (2004) 19 SDSS quasars.
% Input  - fits_filename - the exact name (WITH .fit !!!) of the object.
%                                                   the user can use an array with the 19 Greene objects instead...
%                 begin_wave - the wavelength which marks the begining of
%                              the emmision feature.
%                              [Angstroms]
%                 end_wave - the wavelength which marks the end of
%                            the emmision feature.
%                            [Angstroms]
%                 center - the "central" THEORETICAL wavelength of the
%                          feature , GIVEN IN RESTFRAME VALUES!!!
%                          [Angstroms]
%                 toll - the tollernce of the central feature wavelength;
%                        the range (from each side) in which the user wants the
%                        function to try to find a "better" center.
%                        [Angstroms]
%
%                 
%                 filters - is an N x 2 matrix , which includes filter data - first column for central wavelength , 
%                           and second for FWHM data. 
%                           THIS PROGRAM ASSUMES SIMPLE "RECTANGLE" RESPONSE-CURVES!!!   
%                           if nofilter analisys is needed - enter 0 here.
%
%
%                 mask_type - the type of the mask-array report the user
%                 desires for the feature:  (NOT case sensitive!)
%                                       FULL - for the precentages of the
%                                                    data points which have non-zero mask array data , followed
%                                                    by a full legend which describes the different mask array
%                                                    values.
%                                        PART - as above , without legend
%                                        NONE (or N , or 0) - no mask report


[data,headers]=get1_sdss_spec(fits_filename);
lambda=data(:,1);
z=headers.Z;

rest_lam=lambda./(1+z);
subplot(1,2,1);
plot(rest_lam,data(:,2));

fst_ind=max(find(lambda <= begin_wave));
last_ind=min(find(lambda >= stop_wave));

s_data=data(fst_ind:last_ind,:);
L=length(s_data(:,1));
s_rest_lam=rest_lam(fst_ind:last_ind,:);

cont= ( ((s_data(1,2)-s_data(L,2))/(s_data(1,1)-s_data(L,1))).*(s_data(:,1)-s_data(1,1)) ) +  s_data(1,2)     ; 
%     =  ( (    dy      /      dx   ) * (x-x_1)) + y_1

net_flux=s_data(:,2)-cont;

%the following produces the velocity-chart , centrelized in the rest-frame
veloc_X=3*(10^5)*((s_rest_lam./center)-1);

subplot(1,2,2);
plot(veloc_X,net_flux);

RES.new_data.integral = trapz(s_data(:,1),net_flux); 
RES.new_data.new_Z = z;
RES.new_data.Zdif = 0;
%RES.new_data.FWHM =      ;

if toll ~= 0
    fst_search_ind = max(find(s_rest_lam <= center-toll));
    last_search_ind = min(find(s_rest_lam >= center+toll));
    search_data=s_data(fst_search_ind:last_search_ind,:);
    new_cent_ind = find(max(search_data));
    new_cent=search_data(new_cent_ind,1);
    new_veloc_X=3*(10^5)*((s_rest_lam/new_cent)-1);
    plot(new_veloc_X , net_flux);
    
    RES.new_data.new_Z = ((z+1)*(center/new_cent)) - 1;
    RES.new_data.Zdif = RES.new_data.new_Z - z;
    
    %RES.new_data.FWHM =      ;
end

clear i;

%The following part takes care of the filter calculations
m=length(filters(:,1));
if (m ~= 0)
    tmp_fil(:,1)=filters(:,1)-0.5*filters(:,2); %these 2 lines transform the filter data from "center & windth" to "begin & end"
    tmp_fil(:,2)=filters(:,1)+0.5*filters(:,2);
    tmp_fil(:,3)=filters(:,3);
    for i=1:m
        if (tmp_fil(i,3)==2) % The desired flux result is bounded by the emission line 
            if  (tmp_fil(i,1) > s_data(L,1)) | (tmp_fil(i,2) < s_data(1,1))
                RES.new_data.filters_flux(i)=0;
            else
                if (tmp_fil(i,1) < s_data(1,1))
                    first_fil_ind=s_data(1,1);
                else
                    first_fil_ind=max(find(s_data(:,1) <= tmp_fil(i,1)));
                end;
                if (s_data(L,1) < tmp_fil(i,2))    
                    last_fil_ind=s_data(L,1);
                else
                    last_fil_ind=min(find(s_data(:,1) >= tmp_fil(i,2)));
                end;
                RES.new_data.filters_flux(i)=trapz(s_data(first_fil_ind:last_fil_ind,1) , s_data(first_fil_ind:last_fil_ind,2));
            end;
        end;
        
        if (tmp_fil(i,3)==1) % The desired flux result is NOT bounded by the emission line (TOTAL FILTER FLUX!!!)
            first_fil_ind=max(find(data(:,1) <= tmp_fil(i,1)));
            last_fil_ind=min(find(data(:,1) >= tmp_fil(i,2)));
            RES.new_data.filters_flux(i)=trapz(data(first_fil_ind:last_fil_ind,1) , data(first_fil_ind:last_fil_ind,2));
            
        end;
        
        if (tmp_fil(i,3)==0)
            RES.new_data.filters_flux(i)=0;
        end;
    end;
    clear i;
end;
clear m;   






  
%the following part takes care of the mask-array data
format long g;

[Vals,Nums]=find_different(s_data(:,5));
precent = 100*(Nums/L);

%V=length(Vals);
%for i=1:V
%    hex_vals(i)=dec2hex(Vals(i));
%end;

RES.mask=[Vals,Nums,precent];

if (strcmpi(mask_type,'part')) | (strcmpi(mask_type,'full'))
    disp('       mask values     number of points     precentage')
    disp(RES.mask)
    disp('    ')
    if (strcmpi(mask_type,'full'))
         disp('       0,      /*  OK                                                   */');
         disp('     -47,      /*  Fiber not listed in plugmap file                     */');
         disp('     -46,      /*  Bad trace from routine TRACE320CRUDE                 */');
         disp('     -44,      /*  Low counts in fiberflat                              */');
         disp('     -40,      /*  Bad arc solution                                     */');
         disp('     -38,      /*  More than 10% pixels are bad columns                 */');
         disp('     -28,      /*  More than 10% pixels are rejected in extraction      */');
         disp('      -8,      /*  Large spatial shift between flat and object position */');
         disp('    9913,      /*  Bad pixel within 3 pixels of trace                   */');
         disp('   19913,      /*  Flat field less than 0.5                             */');
         disp('   39913,      /*  Pixel fully rejected in extraction                   */');
         disp('   79913,      /*  Some pixels rejected in extraction                   */');
         disp('   99913,      /*  Scattered light significant                          */');
         disp('  199913,      /*  Cross-talk significant                               */');
         disp('  399913,      /*  Sky level unknown at this wavelength                 */');
         disp('  799913,      /*  Sky level > flux + 10*(flux error)                   */');
         disp('  999913,      /*  No data available in combine B-spline                */');
         disp(' 1999913,      /*  Rejected in combine B-spline                         */');
         disp(' 3999913,      /*  Low flux-calibration or flux-correction factor       */');
         disp(' 7999913,      /*  Chi^2 > 4 in sky residuals at this wavelength        */');
         disp(' 9999913,      /*  Contiguous region of bad chi^2 in sky residuals      */');
         disp('39999913,      /*  Emmission line detected here                         */');
     end
 end
 RES.data=data;
 RES.headers=headers;
 
end;









